<!-- Parent: Arendusvahendid -->
<!-- Label: logging -->
<!-- Label: json-logging -->
<!-- Label: audit -->

# Logimise nõuded tarkvaralahendustele

!!! info
    Juhend logimise arhitektuuri ja äriprotsesside jaoks SMIT majutusplatvormil. Määratleb struktureeritud logimise põhimõtted ja keskse logihalduse nõuded.

Need nõuded määratlevad, kuidas peavad loodavad tarkvara komponendid logima tegevusi, et tagada turvalisus, auditeeritavus ja probleemide lahendamine. Logimine peab olema struktureeritud, turvaline ja sobiv kesksesse logihaldussüsteemi integratsiooniks.

Need nõuded vajavad inimeste järelevalvet, protsessijuhtimist või infrastruktuuri konfigureerimist ja ei ole automaatselt jõustatavad arendusprotsessis.

**Täiendav dokument**: Automaatselt jõustatavate logimise standardite jaoks vaata [rules kausta](https://source.smit.sise/projects/IDP/repos/smit-development-standards/browse/rules) vastava keele spetsiifilised logimise reeglid: `rules/{language}-common/application-logging.mdc` ja `rules/{language}-common/audit-logging.mdc`

## Logimise arhitektuurinõuded ja infrastruktuuriotsused

### 1. Üldised logimise põhimõtted

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 1.1 | Logimiseks tuleb kasutada alus süsteemi võimalusi ja standardseid teeke | KOHUSTUS | Kasutada vastava keele standardseid logimise API-sid. Vt: `rules/{language}-common/application-logging.mdc` |
| 1.2 | Logi peab olema loetav tekstilisel kujul UTF-8 kodeeringus | KOHUSTUS | Kõik logikirjed peavad olema UTF-8 kodeeringus, sh erisümbolid ja eesti keel. Vt: `rules/{language}-common/application-logging.mdc` |
| 1.3 | Süsteemispetsiifilised andmed logikirjes peab võimaluse korral koostama JSON-formaadis | KOHUSTUS | Kasutada vastava keele JSON "encoder'it". Struktureeritud andmed konteksti väljade kaudu. Vt: `rules/{language}-common/application-logging.mdc` |
| 1.4 | Logitavates andmetes tuleb enne logifaili kirjutamist kodeerida kõik mittekuvatavad sümbolid, süsteemispetsiifilised andmed, kasutaja sisestatud väärtused ning välja- ja reaeraldajad | KOHUSTUS | Kasutada "parameterized logging". Vältida "string concatenation" kasutaja sisendiga. Vt: `rules/{language}-common/application-logging.mdc` |
| 1.5 | Juhul kui ühe päringu kohta tekib kirjeid mitmesse logisse, siis peab olema võimalik neid kirjeid ühise välja abil siduda | KOHUSTUS | Kasutada unikaalset korrelatsiooni ID välja. Vältida kellaaja kasutamist korrelatsiooni jaoks. Vt: `rules/{language}-common/application-logging.mdc` |
| 1.6 | Kõik väljanimede kirjeldused, parameetrite nimetused ja muu informatsioon peab olema võimalusel inglise keeles | KOHUSTUS | Logikirjete sisu võib olla eesti keeles, kuid väljanimed ja tehnilised identifikaatorid inglise keeles. Vt: `rules/{language}-common/application-logging.mdc` |

### 2. Logitavate tegevuste nõuded

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 2.1 | Logitud peavad olema kõik autentimise katsed (hoolimata tulemusest) | KOHUSTUS | Sh login, logout, failed authentication, session timeout. Vt: `rules/{language}-common/audit-logging.mdc` |
| 2.2 | Logitud peavad olema kõik kasutajate poolt algatatud tegevused | KOHUSTUS | Sh CRUD operatsioonid, otsingud, faili üleslaadimised, ekspordid. Vt: `rules/{language}-common/audit-logging.mdc` |
| 2.3 | Logitud peavad olema kõik taustaprotsesside tegevused | KOHUSTUS | Sh scheduled jobs, batch processing, data synchronization. Vt: `rules/{language}-common/application-logging.mdc` |
| 2.4 | Logitud peavad olema nii õnnestunud kui ka ebaõnnestunud tegevused | KOHUSTUS | Kasutada vastavaid log tasemeid (INFO, WARN, ERROR). Vt: `rules/{language}-common/application-logging.mdc` |

### 3. Keelatud andmete logimine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 3.1 | Kasutajate autentimisega seotud saladust või salasõna teksti või räsi kujul | KOHUSTUS | Ei tohi logida paroole, tokenite väärtusi, privaatvõtmeid. Vt: `rules/{language}-common/application-logging.mdc` |
| 3.2 | Privaatvõtmed | KOHUSTUS | Ei tohi logida krüptograafilisi võtmeid, sertifikaate. Vt: `rules/{language}-common/application-logging.mdc` |
| 3.3 | Seansivõtme väärtus (nt seansi tokenid või -küpsised) | KOHUSTUS | Logida võib ainult seansivõtmest tuletatud räsi või muud pöördumatut tuletist. Vt: `rules/{language}-common/application-logging.mdc` |
| 3.4 | Andmebaasidest tagastatud päringute täisvastused tekstilisel kujul | KOHUSTUS | Logida võib andmete tagastamise fakti või vastuse pikkust. Vt: `rules/{language}-common/application-logging.mdc` |
| 3.5 | Biomeetriliste andmete väärtust taasesitamist võimaldaval kujul | KOHUSTUS | Ei tohi logida biomeetrilisi andmeid, mis võivad olla taasesitatud. Vt: `rules/{language}-common/application-logging.mdc` |
| 3.6 | Andmed, mille logimise keeld tuleneb õigusaktidest | KOHUSTUS | Sh krediitkaardiandmed, isikuandmed vastavalt GDPR-le. Vt: `rules/{language}-common/application-logging.mdc` |

### 4. Logikirje struktuuri nõuded

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 4.1 | Logikirjes peab sisalduma teave, et vastata küsimustele: kes, millal, mida, kus ja kust süsteemis tegi ning mis oli tegevuse tulemus | KOHUSTUS | Kasutada standardseid konteksti välju: userId, timestamp, action, applicationName, clientIp, result. Vt: `rules/{language}-common/application-logging.mdc` |
| 4.2 | KES - tegevuse teostaja peab olema unikaalne vähemalt teenuse piires | KOHUSTUS | Kasutada `userId` konteksti välja. Automaatprotsessid peavad olema selgelt tuvastatavad. Vt: `rules/{language}-common/application-logging.mdc` |
| 4.3 | MILLAL - ajamärgistus peab sisaldama täpset sündmuse kuupäeva ning kellaaega | KOHUSTUS | UTC ajavööndis, ISO8601 formaadis (YYYY-MM-DDTHH:mm:ss.SSSZ), vähemalt sekundi täpsusega. Vt: `rules/{language}-common/application-logging.mdc` |
| 4.4 | MIDA - logitava tegevuse või sündmuse liik või klass | KOHUSTUS | Kasutada `eventType` konteksti välja. Näiteks: USER_LOGIN, ORDER_CREATED, DATA_EXPORT. Vt: `rules/{language}-common/application-logging.mdc` |
| 4.5 | KUS - süsteemi identifikaator | KOHUSTUS | Kasutada `applicationName` konteksti välja. Võimaldab tuvastada täpse rakenduse ja instantsi. Vt: `rules/{language}-common/application-logging.mdc` |
| 4.6 | KUST - seadme unikaalne identifikaator | KOHUSTUS | Kasutada `clientIp` konteksti välja. IP-aadressi puhul tuvastatav lõppseadme IP-aadress. Vt: `rules/{language}-common/application-logging.mdc` |
| 4.7 | TULEMUS - tegevuse tulemuse kirjeldus | KOHUSTUS | Kasutada `eventResult` konteksti välja. Näiteks: SUCCESS, FAILURE, VALIDATION_ERROR. Vt: `rules/{language}-common/application-logging.mdc` |

### 5. Logide jaotamine ja konfigureerimine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 5.1 | Seansilogi - info kasutajate tuvastamise, rakendusse sisenemiste, väljumiste, seansi aegumise kohta | KOHUSTUS | Struktureeritud logimine eraldi log tasemega või eventType väljaga. Konteinerikeskkonnas stdout/stderr voogude kaudu |
| 5.2 | Tegevuslogi - kogu informatsioon kasutajate ja taustaprotsesside tegevuste kohta | KOHUSTUS | Struktureeritud logimine sisendparameetrite ja väliste ressursside kasutamise infoga. Konteinerikeskkonnas stdout/stderr voogude kaudu |
| 5.3 | Silumislogi - arendajate jaoks vajalik debug info | Soovituslik | Toodangukeskkonnas debug vaikimisi välja lülitatud. Struktureeritud logimine eraldi log tasemega |
| 5.4 | Turvalogi/auditlogi - turvalisusega seotud eeldefineeritud sündmused | KOHUSTUS | Struktureeritud logimine kriitiliste turvalisuse sündmuste jaoks. Rahalisi/juriidilisi tagajärgi toovad tegevused. Vt: `rules/{language}-common/audit-logging.mdc` |
| 5.5 | Vealogi - erinevate veaolukordade info | KOHUSTUS | Struktureeritud logimine eraldi log tasemega. Jaotada tehniliseks ja kasutajate vealogiks |

### 6. Logide edastamine ja kogumine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 6.1 | Logisid peab logi edastav teenus saatma reaalajas SMIT'i kesksesse logihaldussüsteemi | KOHUSTUS | Kasutada log forwarding agenti või syslog protokolli. [Detailsem info siin.](https://wiki.smit.sise/spaces/SEC/pages/152539978/Logide+edastamine+kesksesse+logiserverisse) |
| 6.2 | Kasutusel peab olema ühtne NTP (Network Time Protocol) ajateenus | KOHUSTUS | Kõik süsteemid peavad kasutama sama NTP teenust ajasünkroniseerimiseks |
| 6.3 | Logide keskne kogumine sisaldab reaalajas saadetavate logivoogude vastuvõtmist ja salvestamist | KOHUSTUS | Logihaldussüsteemi konfiguratsioon (nt ELK stack, Splunk) |
| 6.4 | Salvestatud logivoogude arhiveerimist olenevalt saadetavate logide tüübist ja neile kehtestatud säilitustähtaegadest | KOHUSTUS| Automaatne arhiveerimine vastavalt logide tüübile ja säilituspoliitikale |
| 6.5 | Auditlogisi peab edastama SMITi SOCi teenusesse | KOHUSTUS | [SOCi](https://wiki.smit.sise/spaces/SEC/pages/277953207/vSOC+Teenusekirjeldus+-+eestikeelne) teenus võimaldab vastavalt loodud reeglitele tuvastada turvaintsidente logiandmete põhjal. [Liidestamise juhised siin.](https://wiki.smit.sise/spaces/SEC/pages/372477539/%C3%84riteenuste+liidestamine+vSOCiga) |
| 6.6 | Logisi, mis ei ole auditlogid, võib edastada SMITi SOCi teenusesse kui nende pealt on võimalik intsidente tuvastada | Soovituslik | [SOCi](https://wiki.smit.sise/spaces/SEC/pages/277953207/vSOC+Teenusekirjeldus+-+eestikeelne) teenus võimaldab vastavalt loodud reeglitele tuvastada turvaintsidente logiandmete põhjal. [Liidestamise juhised siin.](https://wiki.smit.sise/spaces/SEC/pages/372477539/%C3%84riteenuste+liidestamine+vSOCiga) |

### 7. Logide turvalisus ja krüpteerimine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 7.1 | Logiandmete turvaliseks edastamiseks SMITi kesksesse logihaldussüsteemi väljapoolt SMITi hallatavat taristut peab kasutama VPNi või mTLS-i ühendust | KOHUSTUS | Krüpteeritud ühendus logihaldussüsteemiga |
| 7.2 | Salvestatavad logiandmed signeeritakse digitaalselt | KOHUSTUS | Logikirjete digitaalne allkirjastamine tervikluse tagamiseks |
| 7.3 | Arhiiviväärtusega logide terviklus peab olema tagatud kolmanda poole usaldusteenuse abil | Soovituslik | Näiteks TrueTrail või sarnane teenus |
| 7.4 | Tõestusväärtusega logisid ei tohi hoiustada ega töödelda rakenduse serveris või andmebaasis | KOHUSTUS | Logikirjed on vaid informatiivse väärtusega, mitte tõestusmaterjal |

### 8. Logide ligipääs ja säilitamine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 8.1 | Logikeskkondadele ligipääs peab olema kitsendatud ja piiratud | KOHUSTUS | Ainult autoriseeritud kasutajad logide vaatamiseks ja töötlemiseks. [Detailsem info siin.]( https://wiki.smit.sise/spaces/SEC/pages/198183360/Logide+juurdep%C3%A4%C3%A4sutaotlus)        |
| 8.2 | Logisid on keelatud töödelda väljaspool lubatud keskkondi | KOHUSTUS | Arhiveeritud ja väljaspool logitaristut hoitavad logiandmed on alati krüpteeritud |
| 8.3 | Logisid ei tohi avalikustada ega jagada teistele osapooltele, kui selleks ei ole põhjendatud vajadust | KOHUSTUS | Järgida andmete töötlemisel kehtivaid õigusakte ja konfidentsiaalsuse kohustusi. [Detailsem info siin.](https://wiki.smit.sise/spaces/SEC/pages/218313732/Logide+v%C3%A4ljastamine) |
| 8.4 | Logide säilitustähtaegade määramine ja kustutamine peab vastama andmekogu põhimääruses või teenuse kokkuleppes sätestatud tingimustele | KOHUSTUS | Automaatne logide kustutamine vastavalt säilituspoliitikale. [Detailsem info siin.](https://wiki.smit.sise/spaces/SEC/pages/152540018/Logide+s%C3%A4ilitust%C3%A4htaegade+m%C3%A4%C3%A4ramine+ja+kustutamine)                                       |
| 8.5 | Säilitustähtaja määramisel peab silmas pidama, et ressursikasutus oleks proportsionaalne ja mõistlik | KOHUSTUS | Optimeerida logide mahtu ja säilitusaega |
| 8.6 | Kui logide säilitusaega ei ole teenuse dokumentatsioonis täpsustatud, peab logisid hoidma käesoleva aasta kohta ning säilitama neid kuni ühe aasta | KOHUSTUS | Vaikimisi säilitusaeg 1 aasta |

### 9. Logimise optimeerimine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 9.1 | Logimine peab olema optimeeritud, st et peab vältima liigsete logiandmete edastamist logihaldussüsteemi | KOHUSTUS | Filtreerida logid teenuses, vältida dubleerimist |
| 9.2 | Välja arvatud informatsiooni dubleerimist logides, juhul kui seda ei ole eraldi nõutud | KOHUSTUS | Struktureeritud logimine, vältida korduva info logimist |
| 9.3 | Vajaduse korral filtreeritakse logid teenuses | KOHUSTUS | Kasutada vastava keele logimise filtreid või sarnaseid mehhanisme |

### 10. Logimise dokumentatsioon

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 10.1 | Logide spetsiifika peavad olema kirjeldatud teenuse dokumentatsioonis | KOHUSTUS | Mida logitakse, kuidas sündmused logifailidesse on jagatud, rakendusspetsiifiliste logide struktuur ja detailid |
| 10.2 | Logimisvahendid ja informatsioon logi kohta peab olema kaitstud volitamata muudatuste, hävitamise ja juurdepääsu eest | KOHUSTUS | Logimise konfiguratsiooni ja dokumentatsiooni turvalisus |

### 11. Logimise turvanõuded

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 11.1 | Logimise puhul kehtivad vähemalt sama taseme turvanõuded, mis on rakendatud logitavale teenusele | KOHUSTUS | Logimise turvalisus ei tohi olla madalam kui teenuse turvalisus |
| 11.2 | Kui rakenduse äriloogika ei vasta kehtestatud nõuetele tuleb tehnoloogilist lahendust eelnevalt infoturbeosakonnaga kooskõlastama | KOHUSTUS | Erandjuhtude kooskõlastamine infoturbeosakonnaga |

## Logikirje miinimumnõuded

### Logikirje elementide soovituslik järjestus

```
{when}\t{where}\t{what}\t{whence}\t{who}\t{procid?}\t{result}\t{msg-payload?}
```

### Logikirje miinimumnõuded

1. **KES** - tegevuse teostaja:
   - Peab olema unikaalne vähemalt teenuse piires
   - Peab olema seostatav füüsilise isikuga, kui see on võimalik
   - Automaatprotsessid peavad olema selgelt tuvastatavad

2. **MILLAL** - ajamärgistus:
   - Vähemalt sekundi täpsusega
   - UTC ajavööndis
   - Ajaformaadis ISO8601 koos ajavööndi infoga (YYYY-MM-DDTHH:mm:ss.SSSZ)

3. **MIDA** - logitava tegevuse või sündmuse liik:
   - Üheselt tuvastatav viide objektile või selle komponendile
   - Tegevuse tüüp (login, timeout, search, request, query)
   - Tegevusega seotud muud andmed ja sisendväärtused

4. **KUS** - süsteemi identifikaator:
   - Võimalik teha kindlaks täpne rakendus ja selle instants

5. **KUST** - seadme unikaalne identifikaator:
   - Identifikaatori abil võimalik üheselt tuvastada seade
   - IP-aadressi puhul tuvastatav lõppseadme IP-aadress

6. **TULEMUS** - tegevuse tulemuse kirjeldus:
   - Tulemuse tüüp (success, attempt, failure, error)
   - Vastuse suurus (baitides ja ridade arvuna)

## Kategooriate kokkuvõte

| Sektsioon | Numbreid | Arv | Kohustuslikud | Valikulised |
|-----------|----------|-----|---------------|-------------|
| **1. Üldised logimise põhimõtted** | 1.1-1.6 | 6 | 6 | 0 |
| **2. Logitavate tegevuste nõuded** | 2.1-2.4 | 4 | 4 | 0 |
| **3. Keelatud andmete logimine** | 3.1-3.6 | 6 | 6 | 0 |
| **4. Logikirje struktuuri nõuded** | 4.1-4.7 | 7 | 7 | 0 |
| **5. Logide jaotamine ja konfigureerimine** | 5.1-5.5 | 5 | 4 | 1 |
| **6. Logide edastamine ja kogumine** | 6.1-6.6 | 6 | 5 | 1 |
| **7. Logide turvalisus ja krüpteerimine** | 7.1-7.4 | 4 | 3 | 1 |
| **8. Logide ligipääs ja säilitamine** | 8.1-8.6 | 6 | 6 | 0 |
| **9. Logimise optimeerimine** | 9.1-9.3 | 3 | 3 | 0 |
| **10. Logimise dokumentatsioon** | 10.1-10.2 | 2 | 2 | 0 |
| **11. Logimise turvanõuded** | 11.1-11.2 | 2 | 2 | 0 |
| **Kokku** | - | **51** | **48** | **3** |

## Märkused

- **KOHUSTUS** = Kohustuslik nõue
- **Soovituslik** = Soovitatud/valikuline nõue
- Logimise infrastruktuurinõuded vajavad platvormi/keskkonna seadistamist
- Logimise protsessinõuded vajavad inimeste järelevalvet ja organisatsioonilist vastavust
- Logimise arhitektuurinõuded vajavad inimeste disainiotsuseid
- Logimise turvanõuded vajavad infoturbeosakonna kooskõlastamist

## AI jõustatavad nõuded

Võrdluseks: **19 nõuet** edukalt teisendati AI jõustatavateks reegliteks failides `rules/{language}-common/application-logging.mdc` ja `rules/{language}-common/audit-logging.mdc`, hõlmates:

- Standardse logimise API kasutamine (`rules/{language}-common/application-logging.mdc`)
- JSON-formaadi kasutamine (`rules/{language}-common/application-logging.mdc`)
- Konteksti väljade kasutamine (`rules/{language}-common/application-logging.mdc`)
- "Parameterized logging" kasutamine (`rules/{language}-common/application-logging.mdc`)
- Keelatud andmete vältimine (`rules/{language}-common/application-logging.mdc`)
- Log tasemete kasutamine (`rules/{language}-common/application-logging.mdc`)
- AuditLogger kasutamine (`rules/{language}-common/audit-logging.mdc`)
- Korrelatsiooni ID kasutamine (`rules/{language}-common/application-logging.mdc`)

---

> **📝 Git-managed page:** This content is automatically synced from [IDP Documentation Repository](https://source.smit.sise/projects/IDP/repos/idp-docs/browse/04-development-tools/logging-requirements.md). **Do not edit manually in Confluence** - all changes should be made in Git and will be automatically deployed.
